using Microsoft.VisualBasic;
using System;
using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;
using System.Data.SqlClient;
using System.Runtime.Serialization;


namespace StrataFlix.Business
{
	[Serializable()]public partial class PeopleBO : StrataFlixBaseBO
	{
		
		
		#region " Constructors "
		
		/// <summary>
		/// Initializes a new instance of the PeopleBO class.
		/// </summary>
		/// <remarks></remarks>
		[System.Diagnostics.DebuggerNonUserCodeAttribute()]public PeopleBO()
		{
			//This call is required by the Component Designer.
			this.InitializeComponent();
			//-- Add the necessary handlers
			this.AddHandlers();
		}
		
		/// <summary>
		/// Initializes a new instance of the PeopleBO class.
		/// </summary>
		/// <param name="Container">The IContainer to which this object will be added.</param>
		/// <remarks></remarks>
		[System.Diagnostics.DebuggerNonUserCodeAttribute()]public PeopleBO(System.ComponentModel.IContainer Container)
		{
			//This call adds the component to the given container.
			Container.Add(this);
			//This call is required by the Component Designer.
			this.InitializeComponent();
			//-- Add the necessary handlers
			this.AddHandlers();
		}
		
		/// <summary>
		/// Initializes a new instance of the PeopleBO class.
		/// </summary>
		/// <param name="info">The SerializationInfo for the object.</param>
		/// <param name="context">The StreamingContext for the source stream.</param>
		/// <remarks></remarks>
		protected PeopleBO(SerializationInfo info, StreamingContext context) : base(info, context)
		{
			//This call is required by the Component Designer.
			this.InitializeComponent();
			//-- Add the necessary handlers
			this.AddHandlers();
		}
		
		/// <summary>
		/// Adds the necessary handlers for the PeopleBO class.
		/// </summary>
		/// <remarks></remarks>
		private void AddHandlers()
		{
			this.CheckRulesOnCurrentRow += new MicroFour.StrataFrame.Business.BusinessLayer.CheckRulesOnCurrentRowEventHandler(PeopleBO_CheckRulesOnCurrentRow);
			this.SetDefaultValues += new MicroFour.StrataFrame.Business.BusinessLayer.SetDefaultValuesEventHandler(PeopleBO_SetDefaultValues);
		}
		
		#endregion

        #region Data Retrieval Methods

        public void FillTop100()
        {
            this.FillDataTable("SELECT TOP 100 * FROM People");
        }

        #endregion

		#region " Event Handlers "
		
		/// <summary>
		/// Checks the business rules on the current row
		/// </summary>
		/// <param name="e"></param>
		/// <remarks></remarks>
		private void PeopleBO_CheckRulesOnCurrentRow(MicroFour.StrataFrame.Business.CheckRulesEventArgs e)
		{
			if (! IsCodeUnique())
			{
				this.AddBrokenRule(PeopleBOFieldNames.pl_Code, "Code is already in use.");
			}
		}
		
		/// <summary>
		/// Sets the default values for a new row
		/// </summary>
		/// <remarks></remarks>
		private void PeopleBO_SetDefaultValues()
		{
			pl_CreatedAt = DateTime.Now;
			pl_CreatedBy = MicroFour.StrataFrame.Security.SecurityBasics.CurrentUser.UserPK;
		}



		
		#endregion
		
		#region " Private Methods "
		
		/// <summary>
		/// Determines if the code is unique
		/// </summary>
		/// <returns></returns>
		/// <remarks></remarks>
		private bool IsCodeUnique()
		{
			//-- Establish Locals
			SqlCommand cmd = new SqlCommand("SELECT COUNT(*) FROM People WHERE pl_Code = @code AND pl_pk != @primaryKey");
			
			//-- Create the parms
			cmd.Parameters.AddWithValue("@code", pl_Code).SqlDbType = SqlDbType.VarChar;
			cmd.Parameters.AddWithValue("@primaryKey", pl_pk).SqlDbType = SqlDbType.Int;
			
			//-- Return the results
			return System.Convert.ToInt32(this.ExecuteScalar(cmd)) == 0;
		}
		
		#endregion
		
		#region " Protected Methods "
		
		/// <summary>
		/// Provide additional type descriptors
		/// </summary>
		/// <returns></returns>
		/// <remarks></remarks>
		protected override MicroFour.StrataFrame.Business.FieldPropertyDescriptor[] GetCustomBindablePropertyDescriptors()
		{
			return new MicroFour.StrataFrame.Business.FieldPropertyDescriptor[] {new ReflectionPropertyDescriptor("pl_FullName", typeof(PeopleBO))};
		}
		
		#endregion
		
		#region " Public Methods "
		
		/// <summary>
		/// Retrieves the code for the specified primary key
		/// </summary>
		/// <param name="peoplePk"></param>
		/// <returns></returns>
		/// <remarks></remarks>
		public static string GetCodeByPrimaryKey(int peoplePk)
		{
			//-- Establish Locals
			SqlCommand cmd = new SqlCommand("SELECT pl_Code FROM People WHERE pl_pk = @primaryKey");
			string r = "";
			object results;
			
			//-- Create the parameters
			cmd.Parameters.AddWithValue("@primaryKey", peoplePk).SqlDbType = SqlDbType.Int;
			
			//-- Retrieve the record
			using (PeopleBO bo = new PeopleBO())
			{
				//-- Get the single value
				results = bo.ExecuteScalar(cmd);
				
				//-- See if a value was retrieved
				if ((results != null) && (!(results is DBNull)))
				{
					r = System.Convert.ToString(results);
				}
			}
			
			
			//-- Return the results
			return r;
		}
		
		
		/// <summary>
		/// Retrieves the name elements of the specified person and returns the name only
		/// </summary>
		/// <param name="peoplePk"></param>
		/// <returns></returns>
		/// <remarks></remarks>
		public static string GetFullName(int peoplePk)
		{
			//-- Establish Locals
			SqlCommand cmd = new SqlCommand("SELECT pl_FirstName, pl_LastName, pl_MiddleName FROM People WHERE pl_pk = @primaryKey");
			string r = "Unknown";
			
			//-- Create the parameters
			cmd.Parameters.AddWithValue("@primaryKey", peoplePk).SqlDbType = SqlDbType.Int;
			
			//-- Retrieve the record
			using (PeopleBO bo = new PeopleBO())
			{
				//-- Retrieve the result set
				bo.FillDataTable(cmd);
				
				//-- See if there were any results
				if (bo.Count > 0)
				{
					r = bo.pl_FullName;
				}
			}
			
			
			//-- Return the results
			return r;
		}
		
		/// <summary>
		/// Retrieves a primary key by code
		/// </summary>
		/// <param name="code"></param>
		/// <returns></returns>
		/// <remarks></remarks>
		public static int GetPrimaryKeyByCode(string code)
		{
			//-- Establish Locals
			SqlCommand cmd = new SqlCommand("SELECT pl_pk FROM People WHERE pl_Code = @code");
			object r;
			
			//-- Create the parms
			cmd.Parameters.AddWithValue("@code", code).SqlDbType = SqlDbType.VarChar;
			
			using (PeopleBO bo = new PeopleBO())
			{
				//-- Return the results
				r = bo.ExecuteScalar(cmd);
				
				if (r == null || r == DBNull.Value)
				{
					return 0;
				}
				else
				{
					return System.Convert.ToInt32(r);
				}
			}
			
		}
		
		#endregion
		
		#region " Public Properties "
		
		/// <summary>
		/// The cast members full name
		/// </summary>
		/// <value></value>
		/// <returns></returns>
		/// <remarks></remarks>
		[Browsable(false), BusinessFieldDisplayInEditor(), Description("Persons Full Name"), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]public string pl_FullName
		{
			get
			{
				//-- Establish Locals
				string r = pl_FirstName;
				
				//-- See if there is a middle name
				if (pl_MiddleName.Length > 0)
				{
					r += " " + pl_MiddleName;
				}
				
				//-- See if there is a last name
				if (pl_LastName.Length > 0)
				{
					r += " " + pl_LastName;
				}
				
				//-- Return Results
				return r;
			}
		}
		
		#endregion
		
	}
	
}
